<?php

function fn_getStatVentaAnni(){
	$tsql = "SELECT YEAR(T0.[DocDate]) AS anni, MONTH(T0.[DocDate]) AS mes, T0.[ItemCode], SUM(T0.[Quantity]) AS UNID
			FROM INV1 T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
			WHERE T0.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1)
				AND T1.[U_Nivel1] IN (100, 150, 170, 200, 250)
			GROUP BY YEAR(T0.[DocDate]), MONTH(T0.[DocDate]), T0.[ItemCode]
			ORDER BY YEAR(T0.[DocDate]), MONTH(T0.[DocDate]), T0.[ItemCode]";
	$params = array();
	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
	if($stmt === false){
		die(print_r(sqlsrv_errors(), true));
	} else {
		$qry = "SELECT * FROM tb_stat_venta_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
		$ver = $GLOBALS['connmy']->query($qry);
		if (mysqli_num_rows($ver) > 0){
			$qry = "DELETE FROM tb_stat_venta_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
			$GLOBALS['connmy']->query($qry);
		}
		while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
			$qry = "INSERT INTO tb_stat_venta_anual (anni, mes, ItemCode, und_anual, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['UNID'].",DATE_FORMAT(NOW(), '%m-%Y'));";
			$GLOBALS['connmy']->query($qry);
		}
	}
}

function fn_getStatProduccionAnni(){
	$tsql = "SELECT YEAR(T1.[ShipDate]) as anni, MONTH(T1.[ShipDate]) as mes, T0.[ItemCode], sum(T1.[Quantity]) AS prod_anual
			FROM OWOR T0 INNER JOIN IGN1 T1 ON T1.[BaseRef] = T0.[DocNum] INNER JOIN OIGN T2 ON T2.[DocEntry] = T1.[DocEntry]
			INNER JOIN OITM T3 ON T3.[ItemCode]= T1.[ItemCode]
			INNER JOIN OITM T4 ON T4.[ItemCode] = T0.[ItemCode]
			WHERE T1.[BaseType] = '202' AND T3.[U_Nivel1] IN (100, 150, 170, 200, 250) AND T4.[U_Nivel1] IN (100, 150, 170, 200, 250)
			AND T2.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1)
			GROUP BY YEAR(T1.[ShipDate]), MONTH(T1.[ShipDate]), T0.ItemCode
			ORDER BY YEAR(T1.[ShipDate]), MONTH(T1.[ShipDate]), T0.ItemCode";
	$params = array();
	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
	if($stmt === false){
		die(print_r(sqlsrv_errors(), true));
	} else {
		$qry = "SELECT * FROM tb_stat_produccion_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
		$ver = $GLOBALS['connmy']->query($qry);
		if (mysqli_num_rows($ver) > 0){
			$qry = "DELETE FROM tb_stat_produccion_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
			$GLOBALS['connmy']->query($qry);
		}
		while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
			$qry = "INSERT INTO tb_stat_produccion_anual (anni, mes, ItemCode, prod_anual, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['prod_anual'].",DATE_FORMAT(NOW(), '%m-%Y'));";
			$GLOBALS['connmy']->query($qry);
		}
	}
}

function fn_getSeriesGraficoVenta($item){
	$qry = "SELECT DISTINCT anni FROM tb_stat_venta_anual WHERE ItemCode = '$item' AND fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
	$data = $GLOBALS['connmy']->query($qry);
	return $data;
}

function fn_getMesesGraficoVentas($item, $anni){
	$qry = "SELECT mes FROM tb_stat_venta_anual WHERE ItemCode = '".$item."' AND anni = '$anni' AND fec_get = DATE_FORMAT(NOW(), '%m-%Y')ORDER BY anni DESC LIMIT 2";
	$data = $GLOBALS['connmy']->query($qry);
	return $data;
}

function fn_getDatosGraficoVentas($item, $mes, $anni){
	$qry = "SELECT ifnull(und_anual, 0) as und_anual FROM tb_stat_venta_anual WHERE ItemCode = '".$item."' AND mes = '$mes' AND anni = '$anni' AND fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
	$data = $GLOBALS['connmy']->query($qry);
	return $data;
}

function fn_getSeriesGraficoProduccion($item){
	$qry = "SELECT DISTINCT anni FROM tb_stat_produccion_anual WHERE ItemCode = '$item' AND fec_get = DATE_FORMAT(NOW(), '%m-%Y') ORDER BY anni DESC LIMIT 2";
	$data = $GLOBALS['connmy']->query($qry);
	return $data;
}

function fn_getMesesGraficoProduccion($item, $anni){
	$qry = "SELECT mes FROM tb_stat_produccion_anual WHERE ItemCode = '".$item."' AND anni = '$anni' AND fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
	$data = $GLOBALS['connmy']->query($qry);
	return $data;
}

function fn_getDatosGraficoProduccion($item, $mes, $anni){
	$qry = "SELECT ifnull(prod_anual, 0) as prod_anual FROM tb_stat_produccion_anual WHERE ItemCode = '".$item."' AND mes = '$mes' AND anni = '$anni' AND fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
	$data = $GLOBALS['connmy']->query($qry);
	return $data;
}
?>