<?php

  function fn_setDiasProductivos(){
    $tsql = "SELECT T0.U_Anio, T0.U_Mes, T0.U_DiasProd FROM [dbo].[@DIASPROD]  T0 WHERE T0.[U_Anio] > '2020'";
    $params = array();
    $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
    $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
    if($stmt === false){
      die(print_r(sqlsrv_errors(), true));
    } else {
      while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
        $qryver = "SELECT * FROM tb_plan_param_diasprod WHERE U_Anio = '".$rowDet['U_Anio']."' and U_Mes = '".$rowDet['U_Mes']."'";
        $res1 = $GLOBALS['connmy']->query($qryver);
        if (mysqli_num_rows($res1) == 0){
          $qry = "INSERT INTO tb_plan_param_diasprod (U_Anio, U_Mes, U_DiasProd)
            VALUES (".$rowDet['U_Anio'].",".$rowDet['U_Mes'].",".$rowDet['U_DiasProd'].")";
          $GLOBALS['connmy']->query($qry);
        }
      }
    }
  }

  function fn_getBufferVentas1($item){
  	$tsql = "SELECT isnull(BufferVta, 0) as BufferVta FROM BufferVTA WHERE ItemCode = '$item'";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if (sqlsrv_num_rows($stmt) > 0){
  		$rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC);
	  	if ($rowDet['BufferVta'] == ''){
	  		return '0';
	  	} else {
	  		return $rowDet['BufferVta'];
	  	}
  	} else {
  		return '0';
  	}
  }

  function fn_getBufferVentas2($item){
  	$tsql = "SELECT BufferVta FROM BufferAnual WHERE ItemCode = '$item'";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if (sqlsrv_num_rows($stmt) > 0){
  		$rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC);
  		if ($rowDet['BufferVta'] == ''){
  			return '0';
  		} else {
  			return $rowDet['BufferVta'];
  		}
  	} else {
  		return '0';
  	}
  }

  function fn_getCapacidadesProductivas(){
		$sql = "SELECT DISTINCT fec_get FROM tb_plan_capaprod WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
		$val = $GLOBALS['connmy']->query($sql);
		if (mysqli_num_rows($val) == 0){
	  	$qrydp = "SELECT U_DiasProd FROM tb_plan_param_diasprod WHERE U_Anio = year(curdate()) and U_Mes = MONTH(CURDATE())-1";
	  	$res1 = $GLOBALS['connmy']->query($qrydp);
	  	$dias = $res1->fetch_assoc()['U_DiasProd'];
	  	$tsql = "WITH
	      capa AS (SELECT T0.[DocNum], T0.[PostDate],  T0.[ItemCode] item1, T0.[PlannedQty], T0.[CmpltQty], T2.[DocEntry] doc1, T1.[DocEntry] doc2,
	      		T2.[DocDate], T1.[ShipDate], T1.[BaseRef], T1.[BaseType], T1.[ItemCode] item2, T1.[Quantity], T3.[U_Nivel2]
	      	FROM OWOR T0 INNER JOIN IGN1 T1 ON T1.[BaseRef] = T0.[DocNum] INNER JOIN OIGN T2 ON T2.[DocEntry] = T1.[DocEntry]
	      		INNER JOIN OITM T3 ON T3.[ItemCode]= T1.[ItemCode]
	      		INNER JOIN OITM T4 ON T4.[ItemCode] = T0.[ItemCode]
	      	WHERE T1.[BaseType] = '202' AND T3.[U_Nivel1] IN (100, 150, 170, 200, 250) AND T4.[U_Nivel1] IN (100, 150, 170, 200, 250)
	      		AND T2.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1))
	      SELECT U_Nivel2, SUM(Quantity) AS capacidad
	      FROM capa
	      GROUP BY U_Nivel2
	      ORDER BY U_Nivel2";
	  	$params = array();
	  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
	  	if($stmt === false){
	  		die(print_r(sqlsrv_errors(), true));
	  	} else {
	  		while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
	  			$qry = "SELECT manual FROM tb_plan_capaprod WHERE IDlinea = ".$rowDet['U_Nivel2']." AND
						fec_get = (SELECT DISTINCT fec_get FROM tb_plan_capaprod WHERE IDlinea = ".$rowDet['U_Nivel2']." ORDER BY fec_get DESC LIMIT 1)";
	  			$res1 = $GLOBALS['connmy']->query($qry);
	  			$manual = $res1->fetch_assoc()['manual'];
	  			$tot_anni = $rowDet['capacidad'] / 12;
	  			$tot_mes = $tot_anni / $dias;
	  			if (mysqli_num_rows($res1) > 0){
		  			$qry = "INSERT INTO tb_plan_capaprod (IDlinea, tot_prod, tot_anni, tot_mes, manual, fec_get)
		          VALUES (".$rowDet['U_Nivel2'].",".$rowDet['capacidad'].",".$tot_anni.",".$tot_mes.",".$manual.",DATE_FORMAT(NOW(), '%m-%Y'));";
		  			$GLOBALS['connmy']->query($qry);
	  			} else {
	  				$qry = "INSERT INTO tb_plan_capaprod (IDlinea, tot_prod, tot_anni, tot_mes, manual, fec_get)
		          VALUES (".$rowDet['U_Nivel2'].",".$rowDet['capacidad'].",".$tot_anni.",".$tot_mes.",0,DATE_FORMAT(NOW(), '%m-%Y'));";
	  				$GLOBALS['connmy']->query($qry);
	  			}
	  		}
	  	}
		}
  }

  function fn_getVentaAnni(){
    $tsql = "SELECT YEAR(T0.[DocDate]) AS anni, MONTH(T0.[DocDate]) AS mes, T0.[ItemCode], SUM(T0.[Quantity]) AS UNID
	    FROM INV1 T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
	    WHERE T0.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1) AND T1.[U_Nivel1] IN (100, 150, 170, 200, 250)
	    GROUP BY YEAR(T0.[DocDate]), MONTH(T0.[DocDate]), T0.[ItemCode]";
    $params = array();
    $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
    $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
    if($stmt === false){
      die(print_r(sqlsrv_errors(), true));
    } else {
    	$qry = "SELECT * FROM tb_plan_venta_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
    	$ver = $GLOBALS['connmy']->query($qry);
    	if (mysqli_num_rows($ver) > 0){
    		$qry = "DELETE FROM tb_plan_venta_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
    		$GLOBALS['connmy']->query($qry);
    	}
      while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
        $qry = "INSERT INTO tb_plan_venta_anual (anni, mes, ItemCode, und_anual, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['UNID'].",DATE_FORMAT(NOW(), '%m-%Y'));";
        $GLOBALS['connmy']->query($qry);
      }
    }
  }

  function fn_getVentaTrim(){
  	$tsql = "SELECT YEAR(T0.[DocDate]) AS anni, MONTH(T0.[DocDate]) AS mes, T0.[ItemCode], SUM(T0.[Quantity]) AS UNID
	    FROM INV1 T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
	    WHERE T0.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1) AND T1.[U_Nivel1] IN (100, 150, 170, 200, 250)
	    GROUP BY YEAR(T0.[DocDate]), MONTH(T0.[DocDate]), T0.[ItemCode]";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		$qry = "SELECT * FROM tb_plan_venta_trim WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  		$ver = $GLOBALS['connmy']->query($qry);
  		if (mysqli_num_rows($ver) > 0){
  			$qry = "DELETE FROM tb_plan_venta_trim WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  			$GLOBALS['connmy']->query($qry);
  		}
  		while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
  			$qry = "INSERT INTO tb_plan_venta_trim (anni, mes, ItemCode, und_trim, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['UNID'].",DATE_FORMAT(NOW(), '%m-%Y'));";
  			$GLOBALS['connmy']->query($qry);
  		}
  	}
  }

  function fn_getVentaMensual(){
  	$tsql = "SELECT YEAR(T0.[DocDate]) AS anni, MONTH(T0.[DocDate]) AS mes, T0.[ItemCode], SUM(T0.[Quantity]) AS UNID
	    FROM INV1 T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
	    WHERE T0.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1) AND T1.[U_Nivel1] IN (100, 150, 170, 200, 250)
	    GROUP BY YEAR(T0.[DocDate]), MONTH(T0.[DocDate]), T0.[ItemCode]";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		$qry = "SELECT * FROM tb_plan_venta_mes WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  		$ver = $GLOBALS['connmy']->query($qry);
  		if (mysqli_num_rows($ver) > 0){
  			$qry = "DELETE FROM tb_plan_venta_mes WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  			$GLOBALS['connmy']->query($qry);
  		}
  		while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
  			$qry = "INSERT INTO tb_plan_venta_mes (anni, mes, ItemCode, und_dia, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['UNID'].",DATE_FORMAT(NOW(), '%m-%Y'));";
  			$GLOBALS['connmy']->query($qry);
  		}
  	}
  }

  function fn_getProduccionAnni(){
  	$tsql = "SELECT YEAR(T1.[ShipDate]) as anni, MONTH(T1.[ShipDate]) as mes, T0.[ItemCode], sum(T1.[Quantity]) AS prod_anual
			FROM OWOR T0 INNER JOIN IGN1 T1 ON T1.[BaseRef] = T0.[DocNum] INNER JOIN OIGN T2 ON T2.[DocEntry] = T1.[DocEntry]
			INNER JOIN OITM T3 ON T3.[ItemCode]= T1.[ItemCode]
			INNER JOIN OITM T4 ON T4.[ItemCode] = T0.[ItemCode]
			WHERE T1.[BaseType] = '202' AND T3.[U_Nivel1] IN (100, 150, 170, 200, 250) AND T4.[U_Nivel1] IN (100, 150, 170, 200, 250)
			AND T2.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1)
			GROUP BY YEAR(T1.[ShipDate]), MONTH(T1.[ShipDate]), T0.ItemCode";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		$qry = "SELECT * FROM tb_plan_produccion_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  		$ver = $GLOBALS['connmy']->query($qry);
  		if (mysqli_num_rows($ver) > 0){
  			$qry = "DELETE FROM tb_plan_produccion_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  			$GLOBALS['connmy']->query($qry);
  		}
  		while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
  			$qry = "INSERT INTO tb_plan_produccion_anual (anni, mes, ItemCode, prod_anual, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['prod_anual'].",DATE_FORMAT(NOW(), '%m-%Y'));";
  			$GLOBALS['connmy']->query($qry);
  		}
  	}
  }

  function fn_getProduccionTrim(){
  	$tsql = "SELECT YEAR(T1.[ShipDate]) as anni, MONTH(T1.[ShipDate]) as mes, T0.[ItemCode], sum(T1.[Quantity]) AS prod_anual
			FROM OWOR T0 INNER JOIN IGN1 T1 ON T1.[BaseRef] = T0.[DocNum] INNER JOIN OIGN T2 ON T2.[DocEntry] = T1.[DocEntry]
			INNER JOIN OITM T3 ON T3.[ItemCode]= T1.[ItemCode]
			INNER JOIN OITM T4 ON T4.[ItemCode] = T0.[ItemCode]
			WHERE T1.[BaseType] = '202' AND T3.[U_Nivel1] IN (100, 150, 170, 200, 250) AND T4.[U_Nivel1] IN (100, 150, 170, 200, 250)
			AND T2.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1)
			GROUP BY YEAR(T1.[ShipDate]), MONTH(T1.[ShipDate]), T0.ItemCode";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		$qry = "SELECT * FROM tb_plan_produccion_trim WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  		$ver = $GLOBALS['connmy']->query($qry);
  		if (mysqli_num_rows($ver) > 0){
  			$qry = "DELETE FROM tb_plan_produccion_trim WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  			$GLOBALS['connmy']->query($qry);
  		}
  		while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
  			$qry = "INSERT INTO tb_plan_produccion_trim (anni, mes, ItemCode, prod_trim, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['prod_anual'].",DATE_FORMAT(NOW(), '%m-%Y'));";
  			$GLOBALS['connmy']->query($qry);
  		}
  	}
  }

  function fn_getItemsProduccion(){
  	$niveles = fn_getniveles();
  	$qryppal = "SELECT ItemCode, ItemName FROM tb_plan_maestro WHERE U_Nivel1 IN (".$niveles.") AND NOT U_BAJA = 'Y'";
  	$resppal = $GLOBALS['connmy']->query($qryppal);
  	return $resppal;
  }

  function fn_getItemPorCodigo($item){
  	$qryppal = "SELECT * FROM tb_plan_maestro WHERE ItemCode = '".$item."'";
  	$resppal = $GLOBALS['connmy']->query($qryppal);
  	return $resppal;
  }

  function fn_getItemsMaestro($n1, $n2, $n3, $n4){
  	$donde = 'U_Nivel1 = ' . $n1 . ' ';
  	if ($n2 != ''){
  		$donde .= 'AND U_Nivel2 = ' . $n2 . ' ';
  	}
  	if ($n3 != ''){
  		$donde .= 'AND U_Nivel3 = ' . $n3 . ' ';
  	}
  	if ($n4 != ''){
  		$donde .= 'AND U_Nivel4 = ' . $n4 . ' ';
  	}
  	$qryppal = "SELECT * FROM tb_plan_maestro WHERE " . $donde . " AND NOT U_BAJA = 'Y'";
  	$resppal = $GLOBALS['connmy']->query($qryppal);
  	return $resppal;
  }

  function fn_getDatosBaseCalculada(){
		$fecha = fn_getLastDateMy('tb_plan_base_calculo', 'fec_get');
		$qry = "SELECT a.ItemCode, b.ItemName, a.base_calc_mensual, a.und_recomendada FROM tb_plan_base_calculo a INNER JOIN
			tb_plan_maestro b ON a.ItemCode = b.ItemCode WHERE date_format(a.fec_get, '%Y-%m-%d') = '".$fecha."' and NOT b.U_BAJA = 'Y'";
		$resp = $GLOBALS['connmy']->query($qry);
		return $resp;
  }

  function fn_getBaseCalculoItem($item){
  	$qry = "SELECT mayor, reg_manual FROM tb_plan_movimiento_item WHERE ItemCode = '".$item."' AND fec_get = date_format(now(), '%m-%Y')";
  	$resp = $GLOBALS['connmy']->query($qry);
  	$val = $resp->fetch_assoc();
  	if ($val['reg_manual'] == 0){
  		return $val['mayor'];
  	} else {
  		return $val['reg_manual'];
  	}
  }

  function fn_getBaseCalculo(){
  	$niveles = fn_getniveles();
  	$qry = "SELECT a.ItemCode, (select ifnull(sum(b.und_anual), 0) FROM tb_plan_venta_anual b WHERE b.ItemCode = a.ItemCode and b.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) und_anual,
				 (SELECT ifnull(sum(c.und_trim), 0) FROM tb_plan_venta_trim c WHERE c.ItemCode = a.ItemCode and c.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) und_trim,
				 (SELECT ifnull(sum(d.prod_anual), 0) FROM tb_plan_produccion_anual d WHERE d.ItemCode = a.ItemCode and d.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) prod_anual,
				 (SELECT ifnull(sum(e.prod_trim), 0) FROM tb_plan_produccion_trim e WHERE e.ItemCode = a.ItemCode and e.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) prod_trim,
				 (SELECT ifnull(sum(f.und_dia), 0) FROM tb_plan_venta_mes f WHERE f.ItemCode = a.ItemCode and f.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) und_dia
				FROM tb_plan_maestro a WHERE a.U_Nivel1 IN (".$niveles.") AND NOT a.U_BAJA = 'Y'";
  	$resp = $GLOBALS['connmy']->query($qry);

  	$qry = "SELECT * FROM tb_plan_movimiento_item WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  	$resp1 = $GLOBALS['connmy']->query($qry);
  	if (mysqli_num_rows($resp1) > 0){
  		$qry = "DELETE FROM tb_plan_movimiento_item WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  		$GLOBALS['connmy']->query($qry);
  	}
  	while($fila = $resp->fetch_assoc()){
			$prom = fn_getDiasVentas($fila['ItemCode']);
	  	$und_anual_mes = round($fila['und_anual'] / 12);
	  	$und_trim_mes = round($fila['und_trim'] / 3);
	  	$prod_anual_mes = round($fila['prod_anual'] / 12);
	  	$prod_trim_mes = round($fila['prod_trim'] / 3);
	  	if ($prom == 0){
	  		$und_mes_dia = 0;
	  	} else {
	  		$und_mes_dia = round($fila['und_dia'] / $prom);
	  	}
	  	$valores = array($und_anual_mes, $und_trim_mes, $prod_anual_mes);
	  	rsort($valores);
	  	$qry = "INSERT INTO tb_plan_movimiento_item (ItemCode, und_anual, und_trim, und_mes, prod_anual, prod_trim, mayor, fec_get) VALUES
				('".$fila['ItemCode']."',".$und_anual_mes.",".$und_trim_mes.",".$und_mes_dia.",".$prod_anual_mes.",".$prod_trim_mes.",".$valores[0].",DATE_FORMAT(NOW(), '%m-%Y'))";
	  	$GLOBALS['connmy']->query($qry);
  	}
  }

  function fn_getDiasVentas($item){
  	$qry = "SELECT DISTINCT T0.[DocDate], T0.[ItemCode] FROM INV1 T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
			WHERE T0.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1)
			AND T1.[U_Nivel1] IN (100, 150, 170, 200, 250) AND T0.[ItemCode] = '$item'
			ORDER BY T0.[DocDate]";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $qry , $params, $options);
  	return sqlsrv_num_rows($stmt);
  }

  function fn_getMovimientosItems($fecha, $n1 = '', $n2 = '', $n3 = '', $n4 = ''){
  	$donde = '';
  	if ($n1 != ''){
  		$donde .= 'AND U_Nivel1 = ' . $n1 . ' ';
  	}
  	if ($n2 != ''){
  		$donde .= 'AND U_Nivel2 = ' . $n2 . ' ';
  	}
  	if ($n3 != ''){
  		$donde .= 'AND U_Nivel3 = ' . $n3 . ' ';
  	}
  	if ($n4 != ''){
  		$donde .= 'AND U_Nivel4 = ' . $n4 . ' ';
  	}
  	$qry = "SELECT a.*, b.ItemName FROM tb_plan_movimiento_item a INNER JOIN tb_plan_maestro b ON a.ItemCode = b.ItemCode WHERE a.fec_get = '".$fecha."' " . $donde;
  	$resp = $GLOBALS['connmy']->query($qry);
  	return $resp;
  }

  function fn_getValorRedondeado($item, $valor){
  	$qrymul = "SELECT und_redondeo FROM tb_plan_param_redondeo WHERE ItemCode = '".$item."'";
  	$res1 = $GLOBALS['connmy']->query($qrymul);
  	if (mysqli_num_rows($res1) > 0){
  		$fact = $res1->fetch_assoc()['und_redondeo'];
  		$entero = intval($valor);
  		if ($entero % $fact > 0){
  			$mod = $entero % $fact;
  			$suma = $fact - $mod;
  			$resultado = $entero + $suma;
  		} else {
  			$resultado = $entero;
  		}
  	}
  	return $resultado;
  }

  function fn_getCapacidadLinea($linea){
  	$qrytm = "SELECT a.unif, sum(b.tot_mes) AS cap_linea FROM tb_plan_unificalinea a INNER JOIN tb_plan_capaprod b ON
			a.IDLinea = b.IDlinea WHERE b.fec_get = DATE_FORMAT(NOW(), '%m-%Y') AND a.unif =
				(SELECT unif FROM tb_plan_unificalinea WHERE idlinea = ".$linea.") GROUP BY a.unif";
  	$restm = $GLOBALS['connmy']->query($qrytm);
  	return $restm;
  }

  function fn_getDatosBase(){
  	$niveles = fn_getniveles();
  	$qry = "SELECT a.U_Nivel2, a.ItemCode, a.ItemName, b.und_recomendada, b.base_calc_mensual FROM tb_plan_maestro a
			inner join tb_plan_base_calculo b ON a.ItemCode = b.ItemCode WHERE a.U_Nivel1 IN (".$niveles.") ORDER BY a.U_Nivel2, a.ItemCode";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1;
  }

  function fn_getBuffer($item){
  	$qry = "SELECT buffer_manual FROM tb_plan_param_redondeo where ItemCode = '".$item."'";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1->fetch_assoc()['buffer_manual'];
  }

  function fn_getProduccionMinima($item){
  	$qry = "SELECT prod_minima FROM tb_plan_param_redondeo where ItemCode = '".$item."'";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1->fetch_assoc()['prod_minima'];
  }

  function fn_getProduccionMaxima($item){
  	$qry = "SELECT stock_max FROM tb_plan_param_redondeo where ItemCode = '".$item."'";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1->fetch_assoc()['stock_max'];
  }

  function fn_ofcreada($item, $cant, $usr, $filename){
  	$qry = "INSERT INTO tb_plan_ofcreada (ItemCode, qty, fecha, archivo, usrid) values ('".$item."',".$cant.",'".date("Y-m-d H:i:s")."','".$filename."',".$usr.")";
  	$GLOBALS['connmy']->query($qry);
  	return true;
  }

  function fn_getValidaOrdenGenerada($item, $cant, $usr){
  	$qry = "select * from tb_plan_ofcreada where ItemCode = '$item' AND qty = $cant AND usrid = $usr";
  	$resp = $GLOBALS['connmy']->query($qry);
  	if (mysqli_num_rows($resp)==1){
  		return true;
  	} else {
  		return false;
  	}
  }

  function fn_getParametrosCalculo($env){
  	$qry = "SELECT * FROM tb_plan_param_datoscalc WHERE env = '$env'";
  	$data = $GLOBALS['connmy']->query($qry);
  	return $data;
  }

  function fn_getConsultaPiezasItem($item, $req){
  	$rec = fn_getRecetaItem($item);
  	$resp = true;
  	while($desp = $rec->fetch_assoc()){
  		$disp = fn_getStockDespieceItem($desp['hijo']);
  		$piezas = ($desp['cantidad'] / $desp['cant_padre']) * $req;
  		if ($disp >= $piezas){
  			$resp = true;
  		} else {
  			$resp = false;
  			break;
  		}
  	}
  	return $resp;
  }

  function fn_getCabeceraRecetaItem($item){
  	$qry = "SELECT a.padre, a.cant_padre, b.itemname FROM tb_plan_recetas a
	INNER JOIN tb_plan_maestro b ON a.padre = b.itemcode WHERE a.padre = '".$item."' LIMIT 1";
  	$resp = $GLOBALS['connmy']->query($qry);
  	return $resp;
  }

  function fn_getCabeceraPadresReceta($item){
  	$qry = "SELECT a.hijo, b.itemname FROM tb_plan_recetas a
			INNER JOIN tb_plan_maestro b ON a.hijo = b.itemcode WHERE a.hijo = '".$item."' LIMIT 1";
  	$resp = $GLOBALS['connmy']->query($qry);
  	return $resp;
  }

  function fn_getRecetaItem($item){
  	$qry = "SELECT * FROM tb_plan_recetas WHERE padre = '".$item."' AND fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  	$resp = $GLOBALS['connmy']->query($qry);
  	return $resp;
  }

  function fn_getRecetario(){
  	$qry = "SELECT * FROM tb_plan_recetas WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  	$resp = $GLOBALS['connmy']->query($qry);
  	return $resp;
  }

  function fn_getDerivadosHijo($item){
  	$qry = "SELECT a.padre, b.ItemName FROM tb_plan_recetas a INNER JOIN tb_plan_maestro b ON a.padre = b.ItemCode
			WHERE a.hijo =  '".$item."' AND a.fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
  	$resp = $GLOBALS['connmy']->query($qry);
  	return $resp;
  }

  function fn_getStockDespieceItem($item){
  	$bodegas = fn_getBodegas();
  	$sqry = "SELECT sum(onhand) AS stock FROM oitw WHERE itemcode = '".$item."' and whscode IN (".$bodegas.")";
  	
	  $params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $sqry , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		$rtrn = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
  		return $rtrn['stock'];
  	}
  }

  function fn_getLineaUnificada($ID){
  	$qry = "SELECT unif FROM tb_plan_unificalinea WHERE IDLinea = ".$ID;
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1->fetch_assoc()['unif'];
  }

  function fn_getNombreLinea($ID){
  	$qry = "SELECT Descripcion FROM tb_plan_lineasprod WHERE ID = ".$ID;
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1->fetch_assoc()['Descripcion'];
  }

  function fn_getNombreItem($ItemCode){
  	$qry = "SELECT ItemName FROM tb_plan_maestro WHERE ItemCode = '".$ItemCode."'";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1->fetch_assoc()['ItemName'];
  }

  function fn_getCapacidadesLineas($fecha){
  	$qry = "SELECT a.IDLinea, b.descripcion, a.tot_mes, a.manual FROM tb_plan_capaprod a
			INNER JOIN tb_plan_lineasprod b ON a.IDlinea = b.ID WHERE a.fec_get = '$fecha' ORDER BY a.IDlinea";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1;
  }

  function fn_getStockItem($item){
  	$sqry = "SELECT sum(onhand) AS stock FROM oitw WHERE itemcode = '".$item."' and whscode IN ('1')";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $sqry , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		$rtrn = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
  		return $rtrn['stock'];
  	}
  }

  function fn_getPerdidaIngresos($item, $stock, $base){
  	$dp = fn_getDiasProductivos();
		$precio = fn_getPrecioLista($item);
  	if (($stock - ($base /$dp)*5) < 0) {
  		$perdida_ingreso = ($stock - ($base /$dp)*5) * $precio;
  	} else {
  		$perdida_ingreso = 0;
  	}
  	return $perdida_ingreso;
  }

  function fn_getPrecioLista($item){
  	$params1 = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$qryprc = "SELECT ItemCode, Price FROM ITM1 WHERE pricelist = 1 and ItemCode = '".$item."'";
  	$rsplst = sqlsrv_query($GLOBALS['conn'], $qryprc , $params1, $options);
  	$pvprom = sqlsrv_fetch_array( $rsplst, SQLSRV_FETCH_ASSOC)['Price'];
  	return $pvprom;
  }

  function fn_setCalculoIntermedio(){
  	$data = fn_getDatosBase();
  	$dp = fn_getDiasProductivos();
  	$params = fn_getParametrosCalculo('prd')->fetch_assoc();
  	$fecha = date("W");
  	$qry = "SELECT usrID from tb_aux_calculo WHERE usrID = " .$_SESSION['USERID']. " LIMIT 1";
  	$cant = $GLOBALS['connmy']->query($qry);
  	if (mysqli_num_rows($cant) > 0){
  		$qry = "DELETE FROM tb_aux_calculo WHERE usrID = " .$_SESSION['USERID'];
  		$GLOBALS['connmy']->query($qry);
  	}
  	while ($rows = $data->fetch_assoc()){
  		$unif = fn_getLineaUnificada($rows['U_Nivel2']);
  		$stock = fn_getStockItem($rows['ItemCode']);
  		if ($rows['base_calc_mensual'] == 0){
  			$meses_stock = $stock / $rows['und_recomendada'];
  		} else {
  			$meses_stock = $stock / $rows['base_calc_mensual'];
  		}
  		$stock_x_dias = ($rows['base_calc_mensual']/$dp)*$params['dias_proceso'];
  		$stock_proyectado = $stock - $stock_x_dias;

  		$unidades_a_producir = fn_getValorRedondeado($rows['ItemCode'], $rows['und_recomendada'] - $stock_proyectado);
  		$maximo = fn_getProduccionMaxima($rows['ItemCode']);
  		$minimo = fn_getProduccionMinima($rows['ItemCode']);
  		if(($unidades_a_producir > $maximo) && ($maximo > 0)){
  			$unidades_a_producir = $maximo;
  		}
  		if(($unidades_a_producir < $minimo)){
  			$unidades_a_producir = $minimo;
  		}
  		if ($stock_proyectado > $rows['und_recomendada']){
  			$unidades_a_producir = 0;
  		}
  		$perdida_ingreso = fn_getPerdidaIngresos($rows['ItemCode'], $stock, $rows['base_calc_mensual']);
  		$qry = "INSERT INTO tb_aux_calculo (ItemCode, unif, stock, meses_stk_minimo, stock_proyectado, und_a_producir,
				perdida_ingresos, semana, fec_get, usrID)	VALUES ('".$rows['ItemCode']."',".$unif.",".$stock.",".$meses_stock.",
				".$stock_proyectado.",".$unidades_a_producir.",".$perdida_ingreso.",".$fecha.",DATE_FORMAT(NOW(), '%m-%Y'),
				".$_SESSION['USERID'].")";
  		$GLOBALS['connmy']->query($qry);
  	}
  }

  function fn_getCalculoIntermedio($semana, $usrID = '',$corte_prod){
  	$niveles = fn_getniveles();
  	if ($usrID == ''){
  		$usrID = $_SESSION['USERID'];
  	}
  	$qry = "SELECT c.unif, a.ItemCode, a.ItemName, b.und_recomendada, b.base_calc_mensual, c.stock, c.meses_stk_minimo,
				c.stock_proyectado, c.und_a_producir, c.perdida_ingresos FROM tb_plan_maestro a
				inner join tb_plan_base_calculo b ON a.ItemCode = b.ItemCode INNER JOIN tb_aux_calculo c ON a.ItemCode = c.ItemCode
				AND c.fec_get = DATE_FORMAT(NOW(), '%m-%Y') AND c.semana = ".$semana."
			WHERE a.U_Nivel1 IN (".$niveles.") and NOT a.U_BAJA = 'Y' and c.usrID = ".$usrID." ORDER BY c.unif, c.perdida_ingresos, c.meses_stk_minimo";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1;
  }

  function fn_getCalculoIntermedioPorLinea($semana, $linea, $usrID = ''){
  	$niveles = fn_getniveles();
  	if ($usrID == ''){
  		$usrID = $_SESSION['USERID'];
  	}
  	$qry = "SELECT c.unif, a.ItemCode, a.ItemName, b.und_recomendada, b.base_calc_mensual, c.stock, c.meses_stk_minimo,
				c.stock_proyectado, c.und_a_producir, c.perdida_ingresos FROM tb_plan_maestro a
				inner join tb_plan_base_calculo b ON a.ItemCode = b.ItemCode INNER JOIN tb_aux_calculo c ON a.ItemCode = c.ItemCode
				AND c.fec_get = DATE_FORMAT(NOW(), '%m-%Y') AND c.semana = ".$semana."
			WHERE a.U_Nivel1 IN (".$niveles.") and NOT a.U_BAJA = 'Y' and a.U_Nivel2 = ".$linea." and c.usrID = ".$usrID." ORDER BY c.unif, c.perdida_ingresos, c.meses_stk_minimo";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1;
  }

  function fn_getCalculoParaHistoria($semana, $usrID, $ItemCode){
  	$niveles = fn_getniveles();
  	$qry = "SELECT c.unif, a.ItemCode, a.ItemName, b.und_recomendada, b.base_calc_mensual, c.stock, c.meses_stk_minimo,
				c.stock_proyectado, c.und_a_producir, c.perdida_ingresos FROM tb_plan_maestro a
				inner join tb_plan_base_calculo b ON a.ItemCode = b.ItemCode INNER JOIN tb_aux_calculo c ON a.ItemCode = c.ItemCode
				AND c.fec_get = DATE_FORMAT(NOW(), '%m-%Y') AND c.semana = ".$semana."
			WHERE a.U_Nivel1 IN (".$niveles.") and NOT a.U_BAJA = 'Y' and c.usrID = ".$usrID." AND a.ItemCode = '" . $ItemCode . "' ORDER BY c.unif, c.perdida_ingresos, c.meses_stk_minimo";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1;
  }

  function fn_getCalculoHistorico($semana = ''){
  	if ($semana == ''){
  		$semana = fn_getUltimaSemanaCalculo();
  	}
  	$qry = "SELECT * FROM tb_plan_calcfinal WHERE semana = $semana";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1;
  }

  function fn_getCalculoHistoricoPorLinea($linea, $semana = ''){
  	if ($semana == ''){
  		$semana = fn_getUltimaSemanaCalculo();
  	}
  	$qry = "SELECT * FROM tb_plan_calcfinal WHERE semana = $semana AND linea_unif = $linea AND estado NOT IN ('Despiece Incompleto','Generar')";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1;
  }

  function fn_getUltimaSemanaCalculo(){
  	$qry = "SELECT DISTINCT semana FROM tb_plan_calcfinal ORDER BY semana DESC LIMIT 1";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1->fetch_assoc()['semana'];
  }

  function fn_getOrdenesFabricacionItem($item){
  	$niveles = fn_getniveles();
  	$tsql = "SELECT
				T0.DocNum,
				CONVERT(VARCHAR, T0.PostDate, 105) as PostDate,
				T0.ItemCode,
				T1.ItemName,
				T0.Status,
				T0.PlannedQty,
				T0.CmpltQty,
				T0.Comments
      FROM OWOR T0 INNER JOIN OITM T1 ON T1.ItemCode = T0.ItemCode
      WHERE T0.ItemCode = '".$item."'
				AND T0.Status IN ('P', 'R')
				AND (T0.PlannedQty - T0.CmpltQty) > 0
				
			";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		return $stmt;
  	}
  }

  function fn_getUltimaFechaCalculo(){
  	$qry = "SELECT DISTINCT fec_get FROM tb_plan_calculo ORDER BY fec_get DESC LIMIT 1";
  	$res1 = $GLOBALS['connmy']->query($qry);
  	return $res1;
  }

  function fn_getOrdenesFabricacionVigentes(){
  	$niveles = fn_getniveles();
  	$tsql = "SELECT T0.[DocNum],CONVERT(VARCHAR, T0.[PostDate],105) as PostDate, T0.[ItemCode], T1.[ItemName], T0.[Status], T0.[PlannedQty], T0.[CmpltQty], T0.Comments
        FROM OWOR T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
        WHERE T0.[Status] NOT IN ('C', 'L') AND (T0.[PlannedQty] - T0.[CmpltQty])> 0 AND T1.[U_Nivel1] IN (".$niveles.")
				ORDER BY T0.DocNum desc, T0.PostDate desc";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		return $stmt;
  	}
  }

  function fn_getFullOrdenesFabricacionVigentes(){
  	$tsql = "SELECT T0.[DocNum],CONVERT(VARCHAR, T0.[PostDate],105) as PostDate, T0.[ItemCode], T0.[Status],
					T0.[PlannedQty], T0.[CmpltQty], T0.Comments
        FROM OWOR T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
        WHERE T0.[Status] NOT IN ('C', 'L') AND (T0.[PlannedQty] - T0.[CmpltQty])> 0 AND T1.[U_Nivel1] IN (100, 150, 200, 250)
				ORDER BY T0.DocNum desc, T0.PostDate desc";
  	$params = array();
  	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  	if($stmt === false){
  		die(print_r(sqlsrv_errors(), true));
  	} else {
  		while ($fila = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
  			$item = fn_getItemPorCodigo($fila['ItemCode'])->fetch_assoc();
  			$tli = fn_getLineaUnificada($item['U_Nivel2']);
  			$qry = "INSERT INTO tb_aux_fullof (DocNum, PostDate, ItemCode, linea, status, PlannedQty, CmpltQty, usrID) VALUES
					('".$fila['DocNum']."','".$fila['PostDate']."','".$fila['ItemCode']."',".$tli.",'".$fila['Status']."', ".$fila['PlannedQty'].",
					".$fila['CmpltQty'].", ".$_SESSION['USERID'].")";
  			$GLOBALS['connmy']->query($qry);
  		}
  	}
  }

  function fn_getFullOrdenesFabricacionItem($item){
  	$qry = "SELECT * FROM tb_aux_fullof WHERE ItemCode = '".$item."' AND usrID = ".$_SESSION['USERID']." AND proc = 'N'";
  	$rsp = $GLOBALS['connmy']->query($qry);
  	return $rsp;
  }

  function fn_getFullOrdenesFabricacion(){
  	$qry = "SELECT * FROM tb_aux_fullof WHERE usrID = ".$_SESSION['USERID']." AND proc = 'N' ORDER BY DocNum";
  	$rsp = $GLOBALS['connmy']->query($qry);
  	return $rsp;
  }

  function fn_getFullOrdenesFabricacionPorLinea($linea){
  	$qry = "SELECT * FROM tb_aux_fullof WHERE usrID = ".$_SESSION['USERID']." AND proc = 'N' and linea = $linea ORDER BY DocNum";
  	$rsp = $GLOBALS['connmy']->query($qry);
  	return $rsp;
  }

  function fn_setFullOrdenesItemRevisada($item, $numdoc){
  	$qry = "DELETE FROM tb_aux_fullof WHERE ItemCode = '".$item."' AND usrID = ".$_SESSION['USERID']." AND DocNum = ".$numdoc;
  	$GLOBALS['connmy']->query($qry);
  	return true;
  }

  function fn_getLineas(){
  	$qry = "SELECT ID FROM tb_plan_lineasprod ORDER BY ID";
  	$rsp = $GLOBALS['connmy']->query($qry);
  	return $rsp;
  }

  function fn_getOrdenesPlanificador($linea){
  	$qry = "SELECT ItemCode, status, linea, sum(PlannedQty) AS PlannedQty, sum(CmpltQty) AS CmpltQty, (sum(PlannedQty) - sum(CmpltQty)) AS Faltante
			FROM tb_aux_fullof WHERE linea = $linea AND usrID = ".$_SESSION['USERID']." GROUP BY ItemCode, linea ORDER BY linea, ItemCode";
  	$rsp = $GLOBALS['connmy']->query($qry);
  	return $rsp;
  }

  function fn_getLimpiaOrdenesPlanificador(){
  	$qry = "DELETE FROM tb_aux_fullof WHERE usrID = ".$_SESSION['USERID'];
  	$GLOBALS['connmy']->query($qry);
  }

  function fn_getOrdenesFaltantesPlanificador($linea){
  	$semana = fn_getUltimaSemanaCalculo();
  	$qry = "SELECT linea_unif, ItemCode, und_a_producir, tmo_item, estado FROM tb_plan_calcfinal WHERE linea_unif = $linea AND estado IN
			('Generar', 'Despiece Incompleto') AND semana = ".$semana." AND und_a_producir > 0 ORDER BY linea_unif ASC, estado desc";
  	$rsp = $GLOBALS['connmy']->query($qry);
  	return $rsp;
  }

?>
